<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.RespondentFilter" Theme="Voxco"
    Title="<%$ Resources:Resource, VoxcoReporting%>" EnableViewState="true" Async="true" Codebehind="RespondentFilter.aspx.cs" %>
    
<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
    
<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
	
	<telerik:RadScriptBlock ID="radScriptBlock1" runat="server">
		<script type="text/javascript" >
	        
			function UpdateReportRequest()
			{				
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("UpdateReportRequest");
			}
	        
			function UseCurrentDateChange( _checkBox, _datePicker)
			{
				_datePicker.disabled = _checkBox.checked;
			}
		</script>
    </telerik:RadScriptBlock>
    
    <!-- DataSource Declarations                                        -->
    
    <asp:ObjectDataSource ID="AvailableLanguageDataSource" runat="server" SelectMethod="GetGenericAll" TypeName="Voxco.Reporting.DataSource.LanguagesDS">
    </asp:ObjectDataSource>
             
    <!-- End of DataSource Declarations                                 -->        
        
	<telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" OnAjaxRequest="MainAjaxPanel_OnAjaxRequest">
        
        <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server">
             <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
        </telerik:RadAjaxLoadingPanel>
                
        <asp:Panel ID="FilterPanel" runat="server">
        
			<div id="respondentFilter">
				
				<div class="respondentFilterLeft">
				
					<div id="CasesPanel" runat="server" class="frame">
					
						<asp:Label ID="TitleCases" runat="server" Text="<%$ Resources:Resource, Cases%>" CssClass="title"></asp:Label>						
						 
						<asp:RadioButtonList ID="radioRepondentsFilter" runat="server" RepeatDirection="Horizontal" Font-Size="8pt">
							<asp:ListItem Value="All" Text="<%$ Resources:Resource, All%>" ></asp:ListItem>
							<asp:ListItem Value="Completed" Text="<%$ Resources:Resource, Completed%>"></asp:ListItem>
							<asp:ListItem Value="NotCompleted" Text="<%$ Resources:Resource, NotCompleted%>"></asp:ListItem>
							<asp:ListItem Value="Used" Text="<%$ Resources:Resource, Used%>"></asp:ListItem>
							<asp:ListItem Value="NotUsed" Text="<%$ Resources:Resource, NotUsed%>"></asp:ListItem>
						</asp:RadioButtonList>
		                        						
					</div>
					
					<div id="LastCallPanel" runat="server" class="frame">
					
						<asp:Label ID="TitleLastCall" runat="server" Text="<%$ Resources:Resource, LastCall%>" CssClass="title"></asp:Label>
						
						<asp:RadioButtonList ID="radioFilterOption" runat="server" AutoPostBack="True" RepeatDirection="Horizontal" 
						OnSelectedIndexChanged="radioFilterOption_OnSelectedIndexChanged">
							<asp:ListItem Selected="True" Text="<%$ Resources:Resource, Dates %>" Value="Dates"></asp:ListItem>
							<asp:ListItem Text="<%$ Resources:Resource, CurrentDay %>" Value="CurrentDay"></asp:ListItem>
							<asp:ListItem Text="<%$ Resources:Resource, CurrentWeek %>" Value="CurrentWeek"></asp:ListItem>
							<asp:ListItem Text="<%$ Resources:Resource, CurrentMonth %>" Value="CurrentMonth"></asp:ListItem>
							<asp:ListItem Text="<%$ Resources:Resource, All %>" Value="All"></asp:ListItem>
						</asp:RadioButtonList>
	                        
						<asp:Label ID="Label1" runat="server" Text="<%$ Resources:Resource, From%>" CssClass="paddingLabel"></asp:Label>
				
						<telerik:RadDatePicker ID="LastCallStartDatePicker" runat="server">
							<DatePopupButton ToolTip="<%$ Resources:Resource, OpenCalendar%>" />
							<Calendar runat ="server">
								<SpecialDays> 
									<telerik:RadCalendarDay repeatable="Today" date="">
										<ItemStyle CssClass="radCalToday_Default">
										</ItemStyle> 
									</telerik:RadCalendarDay>
								</SpecialDays>
								<FastNavigationSettings  CancelButtonCaption="<%$ Resources:Resource, Cancel%>" OkButtonCaption="<%$ Resources:Resource, Ok%>" TodayButtonCaption="<%$ Resources:Resource, CurrentMonth%>" />
							</Calendar>
						</telerik:RadDatePicker>
				
						<telerik:RadTimePicker ID="LastCallStartTimePicker" runat="server" Culture="fr-CA"  Font-Size="8pt"
							TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
							<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>"/>
							<TimeView runat="server" Columns="5" TimeFormat="HH:mm"></TimeView>
							<DateInput runat="server" Width="50px" DateFormat="HH:mm" ></DateInput>
						</telerik:RadTimePicker>
						
						<br />
						<asp:Label ID="Label2" runat="server" Text="<%$ Resources:Resource, To%>" CssClass="paddingLabel" Width="24px"></asp:Label>
				
						<telerik:RadDatePicker ID="LastCallEndDatePicker" runat="server">
							<DatePopupButton ToolTip="<%$ Resources:Resource, OpenCalendar%>" />
							<Calendar runat ="server">
								<SpecialDays> 
									<telerik:RadCalendarDay repeatable="Today" date="">
										<ItemStyle CssClass="radCalToday_Default">
										</ItemStyle> 
									</telerik:RadCalendarDay>
								</SpecialDays>
								<FastNavigationSettings  CancelButtonCaption="<%$ Resources:Resource, Cancel%>" OkButtonCaption="<%$ Resources:Resource, Ok%>" TodayButtonCaption="<%$ Resources:Resource, CurrentMonth%>" />
							</Calendar>
						</telerik:RadDatePicker>
				
						<telerik:RadTimePicker runat="server" ID="LastCallEndTimePicker"  Culture="fr-CA"
							TimeView-HeaderText="<%$ Resources:Resource, TimePicker%>">
							<TimePopupButton ToolTip="<%$ Resources:Resource, OpenTimePopUp%>"/>
							<TimeView runat="server" Columns="5" TimeFormat="HH:mm"></TimeView>
							<DateInput runat="server" Width="50px" DateFormat="HH:mm" ></DateInput>
						</telerik:RadTimePicker>
					
					</div>
					
					<div id="EquationPanel" runat="server" class="frame">
						
						<asp:Label ID="TitleEquationFilter" runat="server" Text="<%$ Resources:Resource, EquationFilter%>" CssClass="title"></asp:Label>
						<br />						
						
						<telerik:RadTextBox ID="TxtEquation" runat="server" CssClass="filterExpression paddingLabel" Width="90%">
						</telerik:RadTextBox>													
						
					</div>
					
				</div>			
				
				<div class="respondentFilterRight">
					
					<div id="LanguePanel" runat="server">
						
						<asp:Label ID="TitleLanguages" runat="server" Text="<%$ Resources:Resource, Languages%>" CssClass="title"></asp:Label>
		                
						<telerik:RadGrid ID="grdListLang" runat="server" AllowSorting="True" AutoGenerateColumns="false"
						SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader%>" 
						SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader%>" 
						SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader%>" 
						DataSourceID="AvailableLanguageDataSource" AllowMultiRowSelection="True" 
						OnDataBound="grdListLang_OnDataBound"
						EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
							<MasterTableView DataSourceID="AvailableLanguageDataSource" DataKeyNames="LanguageLabel"> 
								<Columns>
									<telerik:GridClientSelectColumn UniqueName="Selected">
										<HeaderStyle Width="30px" HorizontalAlign="center" />
										<ItemStyle Width="30px" HorizontalAlign="center" />
									</telerik:GridClientSelectColumn>
									<telerik:GridBoundColumn UniqueName="LanguageCode" DataField="LanguageCode" Display="false">
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn UniqueName="LanguageLabel" DataField="LanguageLabel" HeaderText="<%$ Resources:Resource, Name%>">
										<HeaderStyle Width="95%" HorizontalAlign="left" />
										<ItemStyle Width="95%" HorizontalAlign="left" />
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn UniqueName="Invalid" DataField="Invalid" Display="false">
									</telerik:GridBoundColumn>
									<telerik:GridBoundColumn UniqueName="IsSelected" DataField="IsSelected" Display="false" >
									</telerik:GridBoundColumn>
								</Columns>
							</MasterTableView>
							<ClientSettings>
								<Selecting AllowRowSelect="true" />
								<Scrolling AllowScroll="true" UseStaticHeaders="true" />
							</ClientSettings>
						</telerik:RadGrid>

					</div>
					
				</div>
				
			</div>
        </asp:Panel>
	</telerik:RadAjaxPanel>

</asp:Content>

